#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.IO;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.UnitTests
{

	/// <summary>
	/// Summary description for BaseTest.
	/// </summary>
	public class BaseTest
	{
		private bool _refreshData = true;
        //***********************************************************************************************************
        //*
        //*              ATTENTION DEVELOPER  -- IF DEBUGGING UNITTESTS - 
        //*     YOU MAY GET A TYPE INITIALIZER FAILURE ON THE BASETEST CLASS IF THIS ISN'T SET PROPERLY--
        //*
        //*MAKE SURE YOU UPDATE THE configuration.xml FILE, IN THE UNITTEST PROJECT FOLDER
        //*            <database>
        //*                 <serverName>redacted</serverName>        THIS SHOULD BE THE IP_ADDRESS vnn
        //*                 <databaseName>UNITTEST_VBECS_V2101</databaseName>       <-- UPDATE THIS
        //*             </database>
        //*
        //*     I'LL AUTOMATE THIS EVENTUALLY..............
        //***********************************************************************************************************
		private static bool _isAutoBuild;
		private static string _action = "Initial";

        private static StringBuilder _infoDump = new StringBuilder();

        public const string CARRIAGE_RETURN = "\x0D";
        /// <summary>
        /// Static Constructor
        /// </summary>
	    static BaseTest()
	    {
            UnitTestConfig.InitMe();

            _infoDump.AppendLine(Environment.NewLine + new string('*',45));
            _infoDump.AppendLine("SpringConfigFile: " + ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            _infoDump.AppendLine("AppName: " + Common.AppServices.GlobalContext.Instance().AppSettingsReader.AppName);
            _infoDump.AppendLine("DbConfig: " + Common.AppServices.GlobalContext.Instance().DbSettingsReader.PrimaryDbConnectionString);
            _infoDump.AppendLine("AppConfig:" + AppDomain.CurrentDomain.SetupInformation.ConfigurationFile);
            _infoDump.AppendLine(new string('*', 45));

            try
            {
                _isAutoBuild = UnitTestConfig.IsAutoBuild;
            }
            catch
            {
                Assert.Fail(_infoDump.ToString() + "BaseTest Error #1: IsAutoBuild property failed. Most likely the wrong DB or DB does not exist.");
            }

            try
            {
                UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM UnitTestModifications", true);
                Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
            }
            catch
            {
                Assert.Fail(_infoDump.ToString() + "BaseTest Error #2: Not a proper UnitTest database. Review your config settings.");
            }
	    }

	    /// <summary>
	    /// We want the data to get reset ONCE, when the first unit test is run.
	    /// Since all UnitTest clases are SUPPOSED to inherit from this BaseTest class
	    /// We're going to reset it here (AutoBuild seems to run randomly, as far as which classes/tests run first)
	    /// DOH!! NOTE!!!  This Constructor runs BEFORE the user clicks RUN, not sure what happens during autobuild.
	    /// </summary>
	    public BaseTest()
	    {
	        if (_isAutoBuild)
	        {
	            this.SetupMinimalData();
                //Update the database too so future debug runs dont affect it
                UnitTestUtil.RunSQL("UPDATE VbecsGlobalConfig set ParameterValue = 'False' WHERE ParameterName = 'IsAutoBuild'");
                _isAutoBuild = false;

	        }
	    }

	    /// <summary>
		/// Adds required data to a blank database
		/// </summary>
		private void SetupMinimalData()
		{
			try
			{
				//**************************************************************************************************
				//1. The Data wipe clears out the VistaLinkControl table, repopulate using app.config values and init
				//**************************************************************************************************
				_action = "ResetVistaLinkControlTable";
				DataCreator.ResetVistaLinkControlTable();

				_action = "Refresh InterfaceControl Table";
				DataCreator.RefreshInterfaceControlTable();

                //WORKAROUND PUT IN ON 2/18/2014 - LOHSE - FOR VistaLink because the rules are boken and VistALinkConfig has not been coded
                //REMOVE THIS AFTER CARL ADDS IN THIS CODE
			    UnitTestUtil.RunSQL("UPDATE BrokenRuleSet SET IsInitiallyBroken = 0 WHERE FormName = 'VistALinkConfig' AND FieldName LIKE 'Vbecs%'");

				//**************************************************************************************************
				//2. Create our test Division
				//**************************************************************************************************
				//Get the list of divisions from VistA
				_action = "GetDivisionDefListFromVistA";
				VistALinkUnitTestHarness.RequireConnection();
				System.Collections.ICollection _availableVistADivisions = BOL.DivisionDefinition.GetDivisionDefListFromVistA();

				//To create a new division, we use the VistA division as a template
				foreach (BOL.DivisionDefinition vistaDiv in _availableVistADivisions)
				{
					if (vistaDiv.DivisionCode.Trim() == UnitTestConfig.TestDivisionCode.Trim())
					{
						BOL.DivisionBase testDivision = new BOL.DivisionBase(vistaDiv);
						testDivision.UsesLabelPrinter = false;
						testDivision.FacilityGuid = DataCreator.GetRandomRecordGuid(TABLES.Facility.TableName, "IccbbaRegistrationNumber IS NOT NULL");
						testDivision.TimeZoneConfig = new BOL.TimeZoneConfig();
						testDivision.TimeZoneConfig.TimeZone = new BOL.TimeZone('S');
						testDivision.TimeZoneConfig.DaylightSavingsType = Common.DaylightSavingsType.UsaStandard;
						testDivision.LockInactivityTimeoutMin = 5;
						testDivision.AccessionAreaId = 29;		//This is cheating - TODO: Code the VistA RPC call lookup
						testDivision.PrinterName = "VBECS Printer";	//This is also cheating - TODO: Code routine to parse Printers array
						testDivision.IsActive = true;

						//this is total crap, but the division won't save unless you set the common.logonuser
						Common.LogonUser.LogonUserDivisionCode = testDivision.DivisionCode;
						testDivision.PersistDivisionBase(Common.UpdateFunction.UnitTests);
						break;
					}
				}
				UnitTestUtil.RunSQL("UPDATE VamcDivision SET MedicalDirectorName = 'BigSalad'");

				//**************************************************************************************************
				//3. Create the TestUser (TODO: make this generic someday!) -- See TestUser property
				//**************************************************************************************************
				_action = "Create lohse";
                DataCreator.CreateNewUser("DNS   LOHSEG0", "53311", "NDY", "Greg Lohse", "Lohse, Greg", Common.UserRoleType.AdministratorSupervisor);
				VistALinkUnitTestHarness.ReleaseConnection();

				//**************************************************************************************************
				//3. Create the TechUser - some tests are based on security rights
				//**************************************************************************************************
				_action = "Create Vbecs1";
                DataCreator.CreateNewUser("DNS   VBECS1", "53333", "TU1", "User One", "User,One", Common.UserRoleType.Technologist);				

				//**************************************************************************************************
				//4. Create some other guys -- make this more efficient later, this is so devs can run unit tests
				//**************************************************************************************************
				_action = "Create Kman";
                DataCreator.CreateNewUser("DNS   DOBRAK", "53304", "DK1", "Krzysztof Dobranowski", "DOBRANOWSKI,KRZYSZTOF", Common.UserRoleType.AdministratorSupervisor);

                _action = "Create DNS   VBECS2";
                DataCreator.CreateNewUser("DNS   VBECS2", "53334", "TU2", "Test User2", "USER,TWO", Common.UserRoleType.Technologist);

				_action = "Create Jensen";
                DataCreator.CreateNewUser("DNS   JENSEC0", "53325", "CJ1", "Carl Jensen", "JENSEN,CARL", Common.UserRoleType.AdministratorSupervisor); 

				_action = "Create Stedum";
                DataCreator.CreateNewUser("DNS   VANSTC0", "53322", "CVS", "Carrie Van Stedum", "VANSTEDUM,CARRIE", Common.UserRoleType.AdministratorSupervisor);

                _action = "Create RTC Buildbot";    //using a testuser5's DUZ - nobody ever uses 5! 
                DataCreator.CreateNewUser("DNS   _RTCBld4", "53337", "BOT", "RTCBuild Bot", "BOT, RTCBUILD", Common.UserRoleType.AdministratorSupervisor);
                
                //**************************************************************************************************
				//6. Refresh the VistACache data
				//**************************************************************************************************
				VistALinkUnitTestHarness.RequireConnection();
				_action = "UpdateCache";
				DAL.VAL.VistaCache.UpdateCache(5);		//Put the cache data in
				VistALinkUnitTestHarness.ReleaseConnection();

				//**************************************************************************************************
				//7. Create a junker Division
				//**************************************************************************************************
				//To create a new division, we use the VistA division as a template
				_action = "Create Junk Division";
				foreach (BOL.DivisionDefinition vistaDiv in _availableVistADivisions)
				{
					if (vistaDiv.DivisionCode.Trim() != UnitTestConfig.TestDivisionCode.Trim())
					{
						BOL.DivisionBase junkDivision = new BOL.DivisionBase(vistaDiv);
						junkDivision.UsesLabelPrinter = false;
						junkDivision.FacilityGuid = DataCreator.GetRandomRecordGuid(TABLES.Facility.TableName, "IccbbaRegistrationNumber IS NOT NULL");
						junkDivision.TimeZoneConfig = new BOL.TimeZoneConfig();
						junkDivision.TimeZoneConfig.TimeZone = new BOL.TimeZone('S');
						junkDivision.TimeZoneConfig.DaylightSavingsType = Common.DaylightSavingsType.UsaStandard;
						junkDivision.LockInactivityTimeoutMin = 5;
						junkDivision.AccessionAreaId = 29;		//This is cheating - TODO: Code the VistA RPC call lookup
						junkDivision.PrinterName = "VBECS Printer";	//This is also cheating - TODO: Code routine to parse Printers array
						junkDivision.IsActive = true;

						//this is total crap, but the division won't save unless you set the common.logonuser
						Common.LogonUser.LogonUserDivisionCode = junkDivision.DivisionCode;
						junkDivision.PersistDivisionBase(Common.UpdateFunction.UnitTests);
						break;
					}
				}

				Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;		//Set it back
                
                //For locking pending controller
			    UnitTestUtil.RunSQL("UPDATE VbecsUser SET PII                         '");
                    
                //Create a few bloodunits too
			    DataCreator.CreateBloodUnit(false);
                DataCreator.CreateRBCBloodUnit(false);
                DataCreator.CreateBloodUnit(true);
                DataCreator.CreateRBCBloodUnit(true);
			}
			catch(Exception err)
			{
				_isAutoBuild = false;		//set the flag so we dont try to setup the data again
                DAL.VistALink.OpenLibrary.ServerConnectionInfo _appInfo = DAL.VistALink.OpenLibrary.GlobalConfig.GetServerConnectionInfoByHandle("Primary");

                _infoDump.AppendLine("Possible VistA failure in BaseTest.DetupMinimalData().Action=" + _action);
                _infoDump.AppendLine(err.Message);

                _infoDump.AppendLine("VistA IP: " + _appInfo.IPAddress.ToString() + "  Port: " + _appInfo.PortNumber.ToString());
                Assert.Fail(_infoDump.ToString());
			}
		}


		/// <summary>
		/// Add at will!
		/// </summary>
		/// <returns></returns>
		private string GetRandomFakeDiagnosis()
		{
			int randNum = new Random().Next(1,5);

			if (randNum == 1) return("Patient has lazy eye, stare at forehead");
			if (randNum == 2) return("Patient has the dropsies, keep mop handy");
			if (randNum == 3) return("Patient lost legs while urinating in ocean");
			if (randNum == 4) return("Patient's momma makes good pie but has a hair lip");
			if (randNum == 5) return("Patient always smells like pickles");

			return("Patient's butt leaks");

		}

		/// <summary>
		/// Data needs to be retrieved from database
		/// </summary>
		public bool RefreshData
		{
			get
			{
				return(this._refreshData);
			}
			set
			{
				this._refreshData = value;
			}
		}

		/// <summary>
		/// Shortcut to save on typing
		/// </summary>
		public string TestDivisionCode
		{
			get
			{
				return(UnitTestUtil.TestDivision.DivisionCode);
			}
		}

		/// <summary>
		/// This will be me
		/// </summary>
		public BOL.VbecsUser TestUser
		{
			get
			{
				//I create a new one everytime in case a test is wanting to see changes
				return (new BOL.VbecsUser(Environment.UserName));
			}
		}

		/// <summary>
		/// This will be a tech user
		/// </summary>
		public BOL.VbecsUser TechUser
		{
			get
			{
				//This is our tech user
				return (new BOL.VbecsUser("DNS   VBECS2"));
			}
		}

        /// <summary>
        /// Move to static method?
        /// </summary>
		protected void BaseSetUp()
		{
			Common.LogonUser.LogonUserDUZ = "53311";
			if (Common.LogonUser.LogonUserDivisionCode != UnitTestConfig.TestDivisionCode)
			{
				Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
			}
		}						 
	}
}
#endif